/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMergeType;
import filenet.vw.api.VWSchema;
import filenet.vw.api.VWXMLData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.workflow.VWBaseFieldTableModel;
import filenet.vw.toolkit.design.property.workflow.VWTableItemWrapper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.table.VWFieldDataForTable;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.awt.ComponentOrientation;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;

public class VWXMLFieldTableModel
extends VWBaseFieldTableModel
implements IVWPropertyChangeListener {
    private static final int NUM_COLUMNS = 8;
    public static final int COL_SOURCE = 0;
    public static final int COL_NAME = 1;
    public static final int COL_SCHEMA = 2;
    public static final int COL_ELEMENT = 3;
    public static final int COL_ARRAY = 4;
    public static final int COL_MERGE_TYPE = 5;
    public static final int COL_VALUE = 6;
    public static final int COL_DESCRIPTION = 7;
    private static final String DEFAULT_VALUE = "\"\"";
    private JComboBox m_schemaComboBox = null;
    private DefaultComboBoxModel m_elementComboBoxModel = null;
    private JComboBox m_mergeTypeComboBox = null;
    private String m_dummySchemaName = null;
    private String m_dummyElementName = null;
    private Boolean m_dummyIsArray = null;
    private String m_dummyMergeType = null;
    private String m_dummyValue = null;
    private String m_dummyDescription = null;

    public VWXMLFieldTableModel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
        try {
            this.m_dummySchemaName = null;
            this.m_dummyElementName = null;
            this.m_dummyIsArray = Boolean.FALSE;
            this.m_dummyMergeType = VWMergeType.getLocalizedString(3);
            this.m_dummyValue = DEFAULT_VALUE;
            this.m_dummyDescription = null;
            this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public JComboBox getSchemaComboBox() {
        try {
            Object[] schemas;
            if (this.m_schemaComboBox == null) {
                this.m_schemaComboBox = new JComboBox(new DefaultComboBoxModel());
            }
            DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.m_schemaComboBox.getModel();
            cbModel.removeAllElements();
            cbModel.addElement(VWResource.s_noneItemStr);
            if (this.m_authPropertyData != null && (schemas = this.m_authPropertyData.getSchemas()) != null && schemas.length > 0) {
                VWQubbleSort.sort(schemas);
                for (int i = 0; i < schemas.length; ++i) {
                    cbModel.addElement(((VWSchema)schemas[i]).getName());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (this.m_schemaComboBox != null) {
            ComponentOrientation o = ComponentOrientation.getOrientation(Locale.getDefault());
            this.m_schemaComboBox.applyComponentOrientation(o);
        }
        return this.m_schemaComboBox;
    }

    public DefaultComboBoxModel getElementComboBoxModel(int nRowIndex) {
        block6: {
            try {
                VWSchema vwSchema;
                if (this.m_elementComboBoxModel == null) {
                    this.m_elementComboBoxModel = new DefaultComboBoxModel();
                }
                this.m_elementComboBoxModel.removeAllElements();
                this.m_elementComboBoxModel.addElement(VWResource.s_noneItemStr);
                String schemaName = (String)this.getValueAt(nRowIndex, this.getActualColumnIndex(2));
                if (schemaName != null && this.m_authPropertyData != null && (vwSchema = this.m_authPropertyData.getSchema(schemaName)) != null) {
                    String[] elementNames;
                    VWWebServiceUtils wsUtils = this.m_authPropertyData.getWebServiceUtils();
                    String schema = vwSchema.getSchema();
                    if (wsUtils != null && schema != null && schema.length() > 0 && (elementNames = wsUtils.getElementNamesFromSchema(schema)) != null) {
                        for (int i = 0; i < elementNames.length; ++i) {
                            this.m_elementComboBoxModel.addElement(elementNames[i]);
                        }
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorRetrievingSchemaElements, 1);
            }
        }
        return this.m_elementComboBoxModel;
    }

    public JComboBox getMergeTypeComboBox() {
        try {
            if (this.m_mergeTypeComboBox == null) {
                DefaultComboBoxModel<String> cbModel = new DefaultComboBoxModel<String>();
                cbModel.addElement(VWMergeType.getLocalizedString(1));
                cbModel.addElement(VWMergeType.getLocalizedString(3));
                cbModel.addElement(VWMergeType.getLocalizedString(5));
                this.m_mergeTypeComboBox = new JComboBox(cbModel);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (this.m_mergeTypeComboBox != null) {
            ComponentOrientation o = ComponentOrientation.getOrientation(Locale.getDefault());
            this.m_mergeTypeComboBox.applyComponentOrientation(o);
        }
        return this.m_mergeTypeComboBox;
    }

    public void copyItem(int nRowIndex) {
        block4: {
            try {
                VWFieldDefinition fieldDef;
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && (fieldDef = (VWFieldDefinition)wrapper.getValue()) != null && this.m_authPropertyData != null && this.m_authPropertyData.getWorkflowDefinition() != null) {
                    String fieldDefName = VWResource.s_copyOfFieldName.toString(fieldDef.getName());
                    String fieldValue = ((VWXMLData)fieldDef.getValue()).getXML();
                    VWFieldDefinition newFieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingString(fieldDefName, fieldValue, fieldDef.getFieldType(), fieldDef.isArray());
                    if (newFieldDef != null) {
                        newFieldDef.setXMLSchemaName(fieldDef.getXMLSchemaName());
                        newFieldDef.setXMLSchemaElement(fieldDef.getXMLSchemaElement());
                        newFieldDef.setMergeType(fieldDef.getMergeType());
                        newFieldDef.setDescription(fieldDef.getDescription());
                        this.m_authPropertyData.resetFieldCache();
                        this.m_authPropertyData.setDirty();
                        this.m_rowData.addElement(new VWTableItemWrapper(0, newFieldDef));
                        nRowIndex = this.getRowCount() - 2;
                        this.fireTableRowsInserted(nRowIndex, nRowIndex);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(newFieldDef);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 563);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block4;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void deleteItem(int nRowIndex) {
        block6: {
            try {
                VWFieldDefinition fieldDef;
                if (!this.canDeleteRow(nRowIndex)) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.canDelete() && (fieldDef = (VWFieldDefinition)wrapper.getValue()) != null && this.m_authPropertyData != null && this.m_authPropertyData.getWorkflowDefinition() != null) {
                    this.m_authPropertyData.getWorkflowDefinition().deleteField(fieldDef.getName());
                    this.m_authPropertyData.resetFieldCache();
                    this.m_authPropertyData.setDirty();
                    if (wrapper.isOverridden()) {
                        wrapper.deleteOverriddenValue();
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    } else {
                        this.m_rowData.removeElementAt(nRowIndex);
                        this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(fieldDef);
                        this.onRemovedFields(this.m_changedItems);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 565);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reinitialize() {
        try {
            try {
                this.m_dummySchemaName = null;
                this.m_dummyElementName = null;
                this.m_dummyIsArray = Boolean.FALSE;
                this.m_dummyMergeType = VWMergeType.getLocalizedString(3);
                this.m_dummyValue = DEFAULT_VALUE;
                this.m_dummyDescription = null;
                this.getSchemaComboBox();
                super.reinitialize();
                if (this.m_authPropertyData != null) {
                    int i;
                    VWFieldDefinition[] fieldDefs;
                    if (this.m_authPropertyData.getShowInheritedProperties() && (fieldDefs = this.m_authPropertyData.getFields(2)) != null) {
                        for (i = 0; i < fieldDefs.length; ++i) {
                            if (fieldDefs[i].getFieldType() != 128) continue;
                            this.m_rowData.addElement(new VWTableItemWrapper(1, fieldDefs[i]));
                        }
                    }
                    if ((fieldDefs = this.m_authPropertyData.getFields(1)) != null) {
                        for (i = 0; i < fieldDefs.length; ++i) {
                            if (fieldDefs[i].getFieldType() != 128) continue;
                            int nIndex = this.findIndex(fieldDefs[i].getName());
                            if (nIndex != -1) {
                                this.overrideTableItem(nIndex, fieldDefs[i]);
                                continue;
                            }
                            this.m_rowData.addElement(new VWTableItemWrapper(0, fieldDefs[i]));
                        }
                    }
                }
                Object var5_5 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var5_6 = null;
                this.fireTableDataChanged();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fireTableDataChanged();
            throw throwable;
        }
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 0: {
                return Icon.class;
            }
            case 1: 
            case 2: 
            case 3: {
                return String.class;
            }
            case 4: {
                return Boolean.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return VWFieldDataForTable.class;
            }
            case 7: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 8 - this.m_nColumnIndexOffset;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                return VWResource.s_nameStr;
            }
            case 2: {
                return VWResource.s_schema;
            }
            case 3: {
                return VWResource.s_element;
            }
            case 4: {
                return VWResource.s_array;
            }
            case 5: {
                return VWResource.s_mergeType;
            }
            case 6: {
                return VWResource.s_xmlValue;
            }
            case 7: {
                return VWResource.s_descriptionStr;
            }
        }
        return null;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        VWFieldDefinition fieldDef = null;
        try {
            VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
            if (wrapper != null) {
                fieldDef = (VWFieldDefinition)wrapper.getValue();
            }
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 0: {
                    if (wrapper == null) break;
                    return wrapper.getStateIcon();
                }
                case 1: {
                    if (fieldDef != null) {
                        return fieldDef.getName();
                    }
                    return null;
                }
                case 2: {
                    String schemaName = null;
                    schemaName = fieldDef != null ? fieldDef.getXMLSchemaName() : this.m_dummySchemaName;
                    if (schemaName == null || schemaName.length() == 0) {
                        schemaName = VWResource.s_noneItemStr;
                    }
                    return schemaName;
                }
                case 3: {
                    String elementName = null;
                    elementName = fieldDef != null ? fieldDef.getXMLSchemaElement() : this.m_dummyElementName;
                    if (elementName == null || elementName.length() == 0) {
                        elementName = VWResource.s_noneItemStr;
                    }
                    return elementName;
                }
                case 4: {
                    if (fieldDef != null) {
                        return fieldDef.isArray();
                    }
                    return this.m_dummyIsArray;
                }
                case 5: {
                    if (fieldDef != null) {
                        return VWMergeType.getLocalizedString(fieldDef.getMergeType());
                    }
                    return this.m_dummyMergeType;
                }
                case 6: {
                    boolean bIsArray = false;
                    VWXMLData xmlData = null;
                    VWXMLData[] fieldValue = null;
                    String schemaName = null;
                    if (fieldDef != null) {
                        bIsArray = fieldDef.isArray();
                        xmlData = (VWXMLData)fieldDef.getValue();
                    } else {
                        bIsArray = this.m_dummyIsArray;
                        xmlData = new VWXMLData(this.m_dummyValue, this.m_dummySchemaName, this.m_dummyElementName);
                    }
                    if (bIsArray) {
                        VWXMLData[] tmpXMLArray;
                        fieldValue = (VWXMLData[])VWFieldType.stringToValue(xmlData.getXML(), 128, bIsArray);
                        if (fieldValue != null) {
                            VWXMLData[] xmlArray = fieldValue;
                            for (int nIndex = 0; nIndex < xmlArray.length; ++nIndex) {
                                if (xmlArray[nIndex] == null) {
                                    xmlArray[nIndex] = new VWXMLData(DEFAULT_VALUE, xmlData.getSchemaName(), xmlData.getElementName());
                                } else {
                                    xmlArray[nIndex].setElementName(xmlData.getElementName());
                                    xmlArray[nIndex].setSchemaName(xmlData.getSchemaName());
                                }
                                xmlArray[nIndex] = this.convertToDisplayFormat(xmlArray[nIndex]);
                            }
                        } else {
                            fieldValue = new VWXMLData[]{this.convertToDisplayFormat(xmlData)};
                        }
                        if (fieldValue != null && (tmpXMLArray = fieldValue).length > 0) {
                            schemaName = tmpXMLArray[0].getSchemaName();
                        }
                    } else {
                        fieldValue = this.convertToDisplayFormat(xmlData);
                        if (fieldValue != null) {
                            schemaName = ((VWXMLData)fieldValue).getSchemaName();
                        }
                    }
                    VWSchema vwSchema = null;
                    if (schemaName != null) {
                        vwSchema = this.m_authPropertyData.getSchema(schemaName);
                    }
                    VWWebServiceUtils wsUtils = this.m_authPropertyData.getWebServiceUtils();
                    if (fieldDef != null) {
                        return new VWFieldDataForTable(fieldDef.getFieldType(), bIsArray, fieldValue, fieldDef.getName(), vwSchema, wsUtils);
                    }
                    return new VWFieldDataForTable(128, bIsArray, fieldValue, null, vwSchema, wsUtils);
                }
                case 7: {
                    if (fieldDef != null) {
                        return fieldDef.getDescription();
                    }
                    return this.m_dummyDescription;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    return wrapper.isLocal();
                }
                return true;
            }
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (!this.isCellEditable(nRowIndex, nColumnIndex)) {
                return;
            }
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 1: {
                    this.onUpdateName(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdateSchemaName(aValue, nRowIndex);
                    break;
                }
                case 3: {
                    this.onUpdateElementName(aValue, nRowIndex);
                    break;
                }
                case 4: {
                    this.onUpdateIsArray(aValue, nRowIndex);
                    break;
                }
                case 5: {
                    this.onUpdateMergeType(aValue, nRowIndex);
                    break;
                }
                case 6: {
                    this.onUpdateFieldValue(aValue, nRowIndex);
                    break;
                }
                case 7: {
                    this.onUpdateDescription(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        switch (event.getID()) {
            case 563: {
                if (event.getSource() == this) break;
                this.reinitialize();
            }
        }
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        block9: {
            try {
                if (aValue == null || ((String)aValue).length() == 0) {
                    return;
                }
                VWFieldDefinition fieldDef = null;
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    fieldDef = (VWFieldDefinition)wrapper.getValue();
                }
                if (fieldDef != null) {
                    String[] names = new String[]{fieldDef.getName(), aValue.toString()};
                    fieldDef.setName(names[1]);
                    this.m_authPropertyData.setDirty();
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(names[0]);
                    this.m_changedItems.addElement(names[1]);
                    this.onRenamedField(this.m_changedItems);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 564);
                } else if (this.m_authPropertyData != null && this.m_authPropertyData.getWorkflowDefinition() != null) {
                    String fieldName = aValue.toString();
                    if (this.m_authPropertyData.getField(fieldName) != null) {
                        String message = VWResource.s_fieldExists.toString(fieldName);
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), message, 1);
                        return;
                    }
                    fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingString(fieldName, this.m_dummyValue, 128, this.m_dummyIsArray);
                    if (fieldDef != null) {
                        fieldDef.setXMLSchemaName(this.m_dummySchemaName);
                        fieldDef.setXMLSchemaElement(this.m_dummyElementName);
                        fieldDef.setMergeType(this.getMergeType(this.m_dummyMergeType));
                        fieldDef.setDescription(this.m_dummyDescription);
                        this.m_authPropertyData.resetFieldCache();
                        this.m_authPropertyData.setDirty();
                        this.m_dummySchemaName = null;
                        this.m_dummyElementName = null;
                        this.m_dummyIsArray = Boolean.FALSE;
                        this.m_dummyMergeType = VWMergeType.getLocalizedString(3);
                        this.m_dummyValue = DEFAULT_VALUE;
                        this.m_dummyDescription = null;
                        this.m_rowData.addElement(new VWTableItemWrapper(0, fieldDef));
                        this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(fieldDef);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 563);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block9;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateSchemaName(Object aValue, int nRowIndex) {
        block19: {
            block18: {
                try {
                    try {
                        block21: {
                            block20: {
                                if (aValue == null) break block20;
                                if (aValue instanceof String) break block21;
                            }
                            Object var9_3 = null;
                            break block18;
                        }
                        String newSchemaName = (String)aValue;
                        if (newSchemaName.length() == 0 || VWStringUtils.compareIgnoreCase(newSchemaName, VWResource.s_noneItemStr) == 0) {
                            newSchemaName = null;
                        }
                        VWFieldDefinition fieldDef = null;
                        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                        if (wrapper != null) {
                            fieldDef = (VWFieldDefinition)wrapper.getValue();
                        }
                        boolean bNewSchema = false;
                        if (fieldDef != null) {
                            String currentName = fieldDef.getXMLSchemaName();
                            if (currentName != null && newSchemaName != null) {
                                if (!currentName.equalsIgnoreCase(newSchemaName)) {
                                    bNewSchema = true;
                                }
                            } else if (currentName == null && newSchemaName != null) {
                                bNewSchema = true;
                            } else if (currentName != null && newSchemaName == null) {
                                bNewSchema = true;
                            }
                            fieldDef.setXMLSchemaName(newSchemaName);
                            this.m_authPropertyData.setDirty();
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(fieldDef);
                            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 566);
                        } else {
                            this.m_dummySchemaName = newSchemaName;
                        }
                        if (bNewSchema || newSchemaName == null) {
                            this.onUpdateElementName(VWResource.s_noneItemStr, nRowIndex);
                        }
                        break block19;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        Object var9_5 = null;
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_6 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    throw throwable;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        Object var9_4 = null;
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateElementName(Object aValue, int nRowIndex) {
        block11: {
            block10: {
                try {
                    try {
                        block13: {
                            block12: {
                                if (aValue == null) break block12;
                                if (aValue instanceof String) break block13;
                            }
                            Object var7_3 = null;
                            break block10;
                        }
                        String newElementName = (String)aValue;
                        if (newElementName.length() == 0 || VWStringUtils.compareIgnoreCase(newElementName, VWResource.s_noneItemStr) == 0) {
                            newElementName = null;
                        }
                        VWFieldDefinition fieldDef = null;
                        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                        if (wrapper != null) {
                            fieldDef = (VWFieldDefinition)wrapper.getValue();
                        }
                        if (fieldDef != null) {
                            fieldDef.setXMLSchemaElement(newElementName);
                            this.m_authPropertyData.setDirty();
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(fieldDef);
                            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 566);
                            break block11;
                        } else {
                            this.m_dummyElementName = newElementName;
                        }
                        break block11;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        Object var7_5 = null;
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    throw throwable;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        Object var7_4 = null;
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateIsArray(Object aValue, int nRowIndex) {
        block10: {
            block9: {
                try {
                    try {
                        if (aValue == null) {
                            Object var10_3 = null;
                            break block9;
                        }
                        VWFieldDefinition fieldDef = null;
                        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                        if (wrapper != null) {
                            fieldDef = (VWFieldDefinition)wrapper.getValue();
                        }
                        if (fieldDef != null) {
                            Boolean bConvertToArray = (Boolean)aValue;
                            boolean bIsArray = fieldDef.isArray();
                            VWXMLData xmlData = (VWXMLData)fieldDef.getValue();
                            String newValue = this.convertXMLValue(bConvertToArray, bIsArray, xmlData);
                            fieldDef.setValue(newValue, 128, bConvertToArray);
                            this.m_authPropertyData.setDirty();
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(fieldDef);
                            this.onChangedField(fieldDef);
                            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 566);
                            break block10;
                        } else {
                            boolean bIsArray = this.m_dummyIsArray;
                            VWXMLData xmlData = new VWXMLData(this.m_dummyValue, this.m_dummySchemaName, this.m_dummyElementName);
                            this.m_dummyIsArray = (Boolean)aValue;
                            this.m_dummyValue = this.convertXMLValue(this.m_dummyIsArray, bIsArray, xmlData);
                        }
                        break block10;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        Object var10_5 = null;
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_6 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    throw throwable;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        Object var10_4 = null;
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateMergeType(Object aValue, int nRowIndex) {
        block10: {
            block9: {
                try {
                    try {
                        if (aValue == null) {
                            Object var6_3 = null;
                            break block9;
                        }
                        VWFieldDefinition fieldDef = null;
                        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                        if (wrapper != null) {
                            fieldDef = (VWFieldDefinition)wrapper.getValue();
                        }
                        if (fieldDef != null) {
                            fieldDef.setMergeType(this.getMergeType(aValue.toString()));
                            this.m_authPropertyData.setDirty();
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(fieldDef);
                            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 566);
                            break block10;
                        } else {
                            this.m_dummyMergeType = aValue.toString();
                        }
                        break block10;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        Object var6_5 = null;
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    throw throwable;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        Object var6_4 = null;
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateFieldValue(Object aValue, int nRowIndex) {
        block18: {
            block20: {
                block19: {
                    try {
                        try {
                            if (aValue == null) break block18;
                            boolean bIsArray = aValue.getClass().isArray();
                            String newStringValue = null;
                            if (bIsArray) {
                                if (!(aValue instanceof VWXMLData[])) {
                                    Object var13_6 = null;
                                    break block19;
                                }
                                VWXMLData[] xmlArray = (VWXMLData[])aValue;
                                StringBuffer buffer = new StringBuffer("{");
                                if (xmlArray.length > 0) {
                                    for (int nIndex = 0; nIndex < xmlArray.length; ++nIndex) {
                                        if (nIndex > 0) {
                                            buffer.append(",");
                                        }
                                        buffer.append(this.convertToExpressionFormat(xmlArray[nIndex].getXML()));
                                    }
                                } else {
                                    buffer.append(DEFAULT_VALUE);
                                }
                                buffer.append("}");
                                newStringValue = buffer.toString();
                            } else {
                                if (!(aValue instanceof VWXMLData)) {
                                    break block20;
                                }
                                VWXMLData newValue = (VWXMLData)aValue;
                                String xmlStr = newValue.getXML();
                                newStringValue = xmlStr != null && xmlStr.length() > 0 ? this.convertToExpressionFormat(xmlStr) : DEFAULT_VALUE;
                            }
                            VWFieldDefinition fieldDef = null;
                            VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                            if (wrapper != null) {
                                fieldDef = (VWFieldDefinition)wrapper.getValue();
                            }
                            if (fieldDef != null) {
                                if (wrapper.isInherited()) {
                                    VWXMLData currentValue = (VWXMLData)fieldDef.getValue();
                                    if (currentValue != null && VWStringUtils.compare(newStringValue, currentValue.getXML()) != 0) {
                                        String schemaName = fieldDef.getXMLSchemaName();
                                        String schemaElement = fieldDef.getXMLSchemaElement();
                                        int nMergeType = fieldDef.getMergeType();
                                        String description = fieldDef.getDescription();
                                        fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingString(fieldDef.getName(), newStringValue, fieldDef.getFieldType(), bIsArray);
                                        fieldDef.setXMLSchemaName(schemaName);
                                        fieldDef.setXMLSchemaElement(schemaElement);
                                        fieldDef.setMergeType(nMergeType);
                                        fieldDef.setDescription(description);
                                        wrapper.overrideValue(fieldDef);
                                    }
                                } else {
                                    fieldDef.setValue(newStringValue, fieldDef.getFieldType(), bIsArray);
                                }
                                this.m_authPropertyData.setDirty();
                                this.m_changedItems = new Vector();
                                this.m_changedItems.addElement(fieldDef);
                                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 566);
                                break block18;
                            }
                            this.m_dummyValue = newStringValue;
                            break block18;
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                            Object var13_9 = null;
                            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_10 = null;
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        throw throwable;
                    }
                }
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                return;
            }
            Object var13_7 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        Object var13_8 = null;
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateDescription(Object aValue, int nRowIndex) {
        block12: {
            block11: {
                try {
                    try {
                        if (aValue == null) {
                            Object var11_3 = null;
                            break block11;
                        }
                        VWFieldDefinition fieldDef = null;
                        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                        if (wrapper != null) {
                            fieldDef = (VWFieldDefinition)wrapper.getValue();
                        }
                        if (fieldDef != null) {
                            if (wrapper.isInherited()) {
                                String currentDesc = fieldDef.getDescription();
                                if (currentDesc == null || VWStringUtils.compare(aValue.toString(), currentDesc) != 0) {
                                    String fieldValue = ((VWXMLData)fieldDef.getValue()).getXML();
                                    String schemaName = fieldDef.getXMLSchemaName();
                                    String schemaElement = fieldDef.getXMLSchemaElement();
                                    int nMergeType = fieldDef.getMergeType();
                                    fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingString(fieldDef.getName(), fieldValue, fieldDef.getFieldType(), fieldDef.isArray());
                                    fieldDef.setXMLSchemaName(schemaName);
                                    fieldDef.setXMLSchemaElement(schemaElement);
                                    fieldDef.setMergeType(nMergeType);
                                    fieldDef.setDescription(aValue.toString());
                                    wrapper.overrideValue(fieldDef);
                                }
                            } else {
                                fieldDef.setDescription(aValue.toString());
                            }
                            this.m_authPropertyData.setDirty();
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(fieldDef);
                            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 566);
                            break block12;
                        }
                        this.m_dummyDescription = aValue.toString();
                        break block12;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        Object var11_5 = null;
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_6 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    throw throwable;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        Object var11_4 = null;
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    private int getMergeType(String type) {
        try {
            if (VWStringUtils.compare(type, VWMergeType.getLocalizedString(5)) == 0) {
                return 5;
            }
            if (VWStringUtils.compare(type, VWMergeType.getLocalizedString(2)) == 0) {
                return 2;
            }
            if (VWStringUtils.compare(type, VWMergeType.getLocalizedString(6)) == 0) {
                return 6;
            }
            if (VWStringUtils.compare(type, VWMergeType.getLocalizedString(1)) == 0) {
                return 1;
            }
            if (VWStringUtils.compare(type, VWMergeType.getLocalizedString(3)) == 0) {
                return 3;
            }
            if (VWStringUtils.compare(type, VWMergeType.getLocalizedString(4)) == 0) {
                return 4;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    private String convertXMLValue(boolean bConvertToArray, boolean bIsArray, VWXMLData xmlData) {
        if (bConvertToArray) {
            if (!bIsArray) {
                String xmlString = xmlData.getXML();
                if (xmlString != null && xmlString.length() <= 2) {
                    try {
                        xmlData.setXML(xmlString);
                        xmlData = this.convertToDisplayFormat(xmlData);
                        xmlString = this.convertToExpressionFormat(xmlData.getXML());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (xmlString != null && xmlString.length() >= 2) {
                    int nRightIndex;
                    if (xmlString.charAt(0) != '\"') {
                        xmlString = "\"" + xmlString;
                    }
                    if (xmlString.charAt(nRightIndex = xmlString.length() - 1) != '\"') {
                        xmlString = xmlString + "\"";
                    }
                } else {
                    xmlString = DEFAULT_VALUE;
                }
                return "{" + xmlString + "}";
            }
        } else if (bIsArray) {
            try {
                String xmlString = xmlData.getXML();
                VWXMLData[] xmlArray = (VWXMLData[])VWFieldType.stringToValue(xmlString, 128, bIsArray);
                if (xmlArray != null && xmlArray.length > 0) {
                    if (xmlArray[0] != null) {
                        return xmlArray[0].toString();
                    }
                    return DEFAULT_VALUE;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            return DEFAULT_VALUE;
        }
        return xmlData.getXML();
    }

    private VWXMLData convertToDisplayFormat(VWXMLData xmlData) {
        try {
            if (xmlData == null) {
                return null;
            }
            String xmlString = xmlData.getXML();
            if (xmlString != null && xmlString.length() >= 2) {
                int nRightIndex = xmlString.length() - 1;
                if (xmlString.charAt(0) == '\"' && xmlString.charAt(nRightIndex) == '\"' || xmlString.charAt(0) == '\'' && xmlString.charAt(nRightIndex) == '\'') {
                    xmlString = xmlString.substring(1, nRightIndex);
                }
                try {
                    if (xmlString.length() > 0) {
                        xmlString = VWStringUtils.replaceAll(xmlString, DEFAULT_VALUE, "'");
                        xmlString = VWStringUtils.xmlPrettyFormat(xmlString);
                        xmlString = VWStringUtils.replaceAll(xmlString, "\"", DEFAULT_VALUE);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return new VWXMLData(xmlString, xmlData.getSchemaName(), xmlData.getElementName());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private String convertToExpressionFormat(String xmlString) {
        if (xmlString != null && xmlString.length() > 0) {
            xmlString = VWStringUtils.replaceAll(xmlString, DEFAULT_VALUE, "'");
            xmlString = VWStringUtils.replaceAll(xmlString, "\"", "'");
            xmlString = VWStringUtils.replaceAll(xmlString, "\n", "");
            if ((xmlString = VWStringUtils.replaceAll(xmlString, "\t", " ")).charAt(0) != '\"') {
                xmlString = '\"' + xmlString;
            }
            if (xmlString.charAt(xmlString.length() - 1) != '\"') {
                xmlString = xmlString + '\"';
            }
            return xmlString;
        }
        return DEFAULT_VALUE;
    }
}

